package gov.va.med.mhv.phr.backing;

import gov.va.med.mhv.core.util.MessagesStringBuilder;
import gov.va.med.mhv.core.util.Precondition;
import gov.va.med.mhv.phr.util.SessionManagement;
import gov.va.med.mhv.usermgmt.service.PatientServiceResponse;
import gov.va.med.mhv.usermgmt.service.delegate.InPersonAuthenticationServiceDelegate;
import gov.va.med.mhv.usermgmt.service.delegate.ServiceDelegateFactory;
import gov.va.med.mhv.usermgmt.transfer.Patient;

import java.security.Principal;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.atlas.messages.Message;
import org.tigris.atlas.messages.Messages;
import org.tigris.atlas.service.ServiceResponse;

import com.bea.netuix.servlets.controls.content.backing.AbstractJspBacking;

public class ExtractDashboardPatientBacking extends AbstractJspBacking {

	private static final long serialVersionUID = 1L;

	private static final Log LOG = LogFactory
			.getLog(ExtractDashboardPatientBacking.class);

	private static final InPersonAuthenticationServiceDelegate IPA_DELEGATE = ServiceDelegateFactory
			.createInPersonAuthenticationServiceDelegate();

	public void init(HttpServletRequest request, HttpServletResponse response) {
		Precondition.assertNotNull("request", request);
		if (request.getUserPrincipal() == null) {
			// Must set "values checked" only AFTER a user has logged in
			// Values cannot be checked when the session has no user
			SessionManagement.getInstance().setVisibilityValuesChecked(request,
					false);
			if (LOG.isDebugEnabled()) {
				LOG.debug("Portlet access control not yet performed, "
						+ "because session has no user.");
			}
			return;
		}
		final String userName = request.getUserPrincipal().getName();

		if (null != userName) {
			Patient patient = getPatient(request);
			if (null == patient) {
				patient = getIPAedPatient(request).getPatient();
				if (LOG.isDebugEnabled()) {
					LOG.debug("");
				}
				setPatient(request, patient);
			}
		}
	}

	/**
	 * Get the patient if IPAed for the user principal in the session
	 * 
	 * @param request
	 *            The request to obtain the session from
	 * @return The patient service response containing the patient if IPAed, or
	 *         null if not IPAed.
	 */
	private PatientServiceResponse getIPAedPatient(HttpServletRequest request) {
		Precondition.assertNotNull("request", request);
		Principal principal = request.getUserPrincipal();
		Precondition.assertNotNull("principal", principal);
		Precondition.assertNotBlank("principal.name", principal.getName());
		PatientServiceResponse serviceResponse = getIPADelegate()
				.getIPAedPatientForUser(principal.getName());
		if (!hasNotAPatientMessage(serviceResponse)) {
			yieldOnError(serviceResponse, "Failed to obtain IPAed patient");
		}
		return serviceResponse;
	}

	private boolean hasNotAPatientMessage(ServiceResponse serviceResponse) {
		Messages msgs = serviceResponse.getMessages();
		for (Object errObj : msgs.getErrorMessages()) {
			Message m = (Message) errObj;
			if ("user.not.a.patient".equals(m.getKey()))
				return true;
		}
		return false;
	}

	private InPersonAuthenticationServiceDelegate getIPADelegate() {
		return IPA_DELEGATE;
	}

	protected void yieldOnError(ServiceResponse response, String message) {
		if (response.getMessages().hasErrorMessages()) {
			LOG.error(response.getMessages().getErrorMessages());
			MessagesStringBuilder builder = new MessagesStringBuilder();
			builder.append(response.getMessages(), Patient.class);
			LOG.error(builder.getErrorString());
			String infoString = builder.getInfoString();
			if (!StringUtils.isBlank(infoString)) {
				LOG.info(infoString);
			}
			throw new IllegalStateException(message);
		}
	}

	private void setPatient(HttpServletRequest request, Patient patient) {
		SessionManagement.getInstance().setPatient(request, patient);
	}

	private Patient getPatient(HttpServletRequest request) {
		return SessionManagement.getInstance().getPatient(request);
	}
}
